## main function
g.tests_pair = function(E, n, test.type="all", perm=0){
  sample1ID = 1:n
  sample2ID = (n+1):(2*n)
  temp = getR1R2_pair(E,1:n)
  R1 = temp$R1
  R2 = temp$R2
  temp = getMV_pair(E,n)
  mu1 = temp$mu1
  var1 = temp$var1
  cov12 = temp$cov12
  
  if (is.na(match(test.type,c("all","original","o","scaled","s","generalized","g")))){
    message("Wrong test.type input! All tests are performed!\n")
    test.type="all"
  }
  if (test.type=="all" || test.type=="original" || test.type=="o"){
    Zo = (R1+R2-2*mu1)/sqrt(var1*2+2*cov12)
    po.approx = pnorm(-Zo)
    ro = list(test.statistic=Zo, pval.approx=po.approx)
  }
  if (test.type=="all" || test.type=="scaled" || test.type=="s"){
    Zs = (R1-R2)/sqrt(var1*2-2*cov12)
    ps.approx = 2*pnorm(-abs(Zs))
    rs = list(test.statistic=Zs, pval.approx=ps.approx)
  }
  if (test.type=="all" || test.type=="generalized" || test.type=="g"){
    S = matrix(c(var1,cov12,cov12,var1), nrow=2)
    Sinv = solve(S)
    Rmv = c(R1-mu1, R2-mu1)
    Zg = Rmv %*% Sinv %*% Rmv
    Zg = Zg[1]
    pg.approx = pchisq(Zg, df=2, lower.tail=FALSE)
    rg = list(test.statistic=Zg, pval.approx=pg.approx)
  }
  
  if (perm>0){
    R1.p = R2.p = rep(0,perm)
    for (k in 1:perm){
      temp.g = sample(1:2,n,replace=TRUE)
      g = c(sample1ID[which(temp.g==1)],sample2ID[which(temp.g==2)])
      temp.p = getR1R2_pair(E,g)
      R1.p[k] = temp.p$R1
      R2.p[k] = temp.p$R2
    }
    if (test.type=="all" || test.type=="original" || test.type=="o"){
      po.perm = (length(which((R1.p+R2.p)>(R1+R2)))+length(which((R1.p+R2.p)==(R1+R2)))/2)/perm
      ro = c(ro, list(pval.perm=po.perm))
    }
    if (test.type=="all" || test.type=="scaled" || test.type=="s"){
      ps.perm = (length(which(abs(R1.p-R2.p)>abs(R1-R2)))+length(which(abs(R1.p-R2.p)==abs(R1-R2)))/2)/perm
      rs = c(rs, list(pval.perm=ps.perm))
    }
    if (test.type=="all" || test.type=="generalized" || test.type=="g"){
      Rmv.p = cbind(R1.p-mu1, R2.p-mu1)
      Zg.p = rowSums((Rmv.p %*% Sinv) * Rmv.p)
      pg.perm = (length(which(Zg.p>Zg))+length(which(Zg.p==Zg))/2)/perm
      rg = c(rg, list(pval.perm=pg.perm))
    }
  }
  r = list()
  if (test.type=="all" || test.type=="original" || test.type=="o"){
    r = c(r,list(original=ro))
  }
  if (test.type=="all" || test.type=="scaled" || test.type=="s"){
    r = c(r,list(scaled=rs))
  }
  if (test.type=="all" || test.type=="generalized" || test.type=="g"){
    r = c(r,list(generalized=rg))
  }
  
  return(r)
}

## supporting functions
getR1R2_pair = function(E,group1){
  R1 = R2 = 0
  n = length(group1)
  ids = which(E[,2]-E[,1]!=n)
  E.remain = E[ids,]

  for (i in 1:nrow(E.remain)){
      e1 = is.na(match(E.remain[i,1],group1))
      e2 = is.na(match(E.remain[i,2],group1))     
      if ((!e1) && (!e2))  R1 = R1 + 1
      if (e1 && e2)  R2 = R2 + 1
  }
  return(list(R1=R1, R2=R2))
}

getMV_pair = function(E,n){
  N = 2*n
  ids = which(abs(E[,2]-E[,1])!=n)
  E.remain = E[ids,]
  G1bynode = vector("list", N)
  for (i in 1:N) G1bynode[[i]] = rep(0,0)
  for (i in 1:nrow(E.remain)){
    G1bynode[[E.remain[i,1]]] = c(G1bynode[[E.remain[i,1]]], E.remain[i,2])
    G1bynode[[E.remain[i,2]]] = c(G1bynode[[E.remain[i,2]]], E.remain[i,1])
  }
  nodedeg = rep(0,N)
  for (i in 1:N) nodedeg[i] = length(G1bynode[[i]])
  G.re = nrow(E.remain)
  
  D = tempac = 0
  for (i in 1:nrow(E.remain)) {
    p1 = E.remain[i,1] 
    p2 = E.remain[i,2] 
    cp1 = ifelse(p1>n,p1-n,p1+n)
    cp2 = ifelse(p2>n,p2-n,p2+n)
    if(cp1%in%G1bynode[[cp2]]) D = D + 1
    tempac = tempac + p1%in%G1bynode[[cp2]] + p2%in%G1bynode[[cp1]] 
  }
  mu1 = G.re/4
  var1 = (G.re+D-tempac+sum((nodedeg[1:n]-nodedeg[(n+1):(2*n)])^2))/16
  cov12 = (G.re+D-tempac-sum((nodedeg[1:n]-nodedeg[(n+1):(2*n)])^2))/16
  return(list(mu1=mu1,var1=var1,cov12=cov12))
}






