% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslhd.R
\name{fslrange}
\alias{fslrange}
\title{Get range of an image}
\usage{
fslrange(file, robust = FALSE, verbose = TRUE, ts = FALSE, ...)
}
\arguments{
\item{file}{(character) filename of image to be checked}

\item{robust}{(logical) Should the range be robust (\code{-r})}

\item{verbose}{(logical) print out command before running}

\item{ts}{(logical) is the series a timeseries (4D), invoking \code{-t} 
option}

\item{...}{options passed to \code{\link[neurobase]{checkimg}}}
}
\value{
numeric vector of length 2
}
\description{
This function calls \code{fslstats -R} to get the range of an image or \code{fslstats -r} to 
get the robust range
}
\examples{
if (have.fsl()){
 mnifile = file.path(fsldir(), "data", "standard", 
   "MNI152_T1_2mm.nii.gz")
 fslrange(mnifile)
}  
}
