% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{vis.paths.along.verts}
\alias{vis.paths.along.verts}
\title{Visualize several paths in different colors.}
\usage{
vis.paths.along.verts(
  surface_vertices,
  paths,
  color = viridis::viridis(length(paths))
)
}
\arguments{
\item{surface_vertices}{float matrix of size (n, 3), the surface vertex coordinates, as returned as part of \code{\link[fsbrain]{subject.surface}} or \code{\link[freesurferformats]{read.fs.surface}}, in the member "vertices". Can also be a \code{freesurferformats::fs.surface} or \code{rgl::tmesh3d} instance, in which case the coordinates are extracted automatically.}

\item{paths}{list of positive integer vectors, the vertex indices of the paths}

\item{color}{a color string, like '#FF0000' to color the path.}
}
\description{
Visualize several paths in different colors.
}
