% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipboard_path.R
\name{clipboard_path}
\alias{clipboard_path}
\title{Copy a Path from Clipboard to '\R'}
\usage{
clipboard_path()
}
\value{
The de-windowsified path.
}
\description{
I often have to work under Windows, where file paths cannot just be pasted
into the code, so I adapted code from
\url{https://www.r-bloggers.com/2015/12/stop-fiddling-
around-with-copied-paths-in-windows-r/}.
Under Windows, the de-windowsified path is copied to the clipboard.
}
\note{
It makes only sense to call \code{clipboard_path} in an interactive \R
session.
}
\seealso{
Other operating system functions: 
\code{\link{file_copy}()},
\code{\link{file_save}()},
\code{\link{get_boolean_envvar}()},
\code{\link{get_run_r_tests}()},
\code{\link{is_installed}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_success}()},
\code{\link{is_windows}()},
\code{\link{view}()},
\code{\link{vim}()},
\code{\link{wipe_tempdir}()},
\code{\link{with_dir}()}

Other file utilities: 
\code{\link{delete_trailing_blank_lines}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{file_string}()},
\code{\link{find_files}()},
\code{\link{get_lines_between_tags}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{grep_file}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{runsed}()},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
\concept{operating system functions}
