% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_number}
\alias{format_number}
\alias{format_number.integer}
\alias{format_number.bignum_biginteger}
\alias{format_number.numeric}
\alias{format_number.bignum_bigfloat}
\alias{format_number.default}
\title{Format a vector of numbers}
\usage{
format_number(x, ...)

\method{format_number}{integer}(x, bigmark = TRUE, ...)

\method{format_number}{bignum_biginteger}(x, bigmark = TRUE, ...)

\method{format_number}{numeric}(x, bigmark = TRUE, ...)

\method{format_number}{bignum_bigfloat}(x, bigmark = TRUE, ...)

\method{format_number}{default}(x, ...)
}
\arguments{
\item{x}{A vector of numbers to format. The friendlynumber package defines
methods for integer, numeric, \code{\link[bignum:biginteger]{bignum::biginteger()}}, and
\code{\link[bignum:bigfloat]{bignum::bigfloat()}} numbers.}

\item{...}{Additional arguments passed to or from other methods.}

\item{bigmark}{\verb{[TRUE / FALSE]}

Whether the thousands places of formatted numbers should be separated with
a comma (e.g. \code{"10,000,000"} vs. \code{"10000000"}). \code{bigmark} is \code{TRUE} by
default.}
}
\value{
A non-NA character vector of the same length as \code{x}.
}
\description{
Format a vector of numbers using \code{format()}.
}
\details{
The number of decimal digits shown in the output of \code{format_number()} is
controlled the \code{friendlynumber.numeric.digits} option for numeric vectors
and \code{friendlynumber.bigfloat.digits} for \code{\link[bignum:bigfloat]{bignum::bigfloat()}} vectors.

These options also control the number of decimal digits translated by
\code{\link[=numeric_friendly]{numeric_friendly()}} and \code{\link[=bigfloat_friendly]{bigfloat_friendly()}} respectively. Because of
this, \code{format_number()} is useful for verifying that the output of these
\verb{*_friendly()} functions is correct.
}
\examples{
format_number(c(1/3, 0, 0.999, NA, NaN, Inf, -Inf))
format_number(c(1L, 2L, 1001L))
format_number(1001L, bigmark = FALSE)

# Set `friendlynumber.numeric.digits` to control the decimal output
opts <- options()
options(friendlynumber.numeric.digits = 2)
format_number(1234.1234)
options(opts)

if (requireNamespace("bignum", quietly = TRUE)) {
  format_number(bignum::bigfloat(1234.1234))
  format_number(bignum::biginteger(2000000))

  # Set `friendlynumber.bigfloat.digits` to control the decimal output
  opts <- options()
  options(friendlynumber.bigfloat.digits = 3)
  format_number(bignum::bigfloat(1234.1234))
  options(opts)
}
}
