% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mri_mask.R
\name{mri_mask}
\alias{mri_mask}
\title{Use Freesurfers MRI Mask}
\usage{
mri_mask(file, mask, outfile = NULL, retimg = TRUE, opts = "", ...)
}
\arguments{
\item{file}{(character) input filename}

\item{mask}{(character) mask filename}

\item{outfile}{(character) output filename}

\item{retimg}{(logical) return image of class nifti}

\item{opts}{(character) additional options to \code{mri_mask}}

\item{...}{additional arguments passed to \code{\link{fs_cmd}}.}
}
\value{
Character or nifti depending on \code{retimg}
}
\description{
This function calls \code{mri_mask} to mask an image
}
\examples{
if (have_fs() && requireNamespace("oro.nifti", quietly = TRUE)) {
   img = oro.nifti::nifti(array(rnorm(5*5*5), dim = c(5,5,5)))  
   mask = img > 1
   res = mri_mask(img, mask)
}
}
