% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework_view.R
\name{view_detail}
\alias{view_detail}
\title{View data with enhanced browser-based interface}
\usage{
view_detail(x, title = NULL, max_rows = 5000)
}
\arguments{
\item{x}{The data to view (data.frame, plot, list, function, or other R object)}

\item{title}{Optional title for the view. If NULL, uses the object name.}

\item{max_rows}{Maximum number of rows to display for data frames (default: 5000).
Large data frames are automatically truncated with a warning.}
}
\value{
Invisibly returns NULL. Function is called for its side effect of
opening a browser window with the rendered view.
}
\description{
Opens an interactive, browser-based viewer for R objects with search, filtering,
sorting, pagination, and export capabilities (CSV/Excel). Provides a rich
DataTables interface for data frames and enhanced views for plots, lists, and
other R objects. This is the recommended function for exploring data in detail.
}
\details{
Unlike R's built-in \code{View()}, this function:
\itemize{
\item Works consistently across all IDEs (VS Code, RStudio, Positron, terminal)
\item Provides search and column filtering
\item Allows export to CSV and Excel
\item Offers sorting and pagination
\item Respects IDE-native viewers (doesn't override them)
}
}
\seealso{
\code{\link{view}}
}
\keyword{internal}
