% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{.parse_package_spec}
\alias{.parse_package_spec}
\title{Parse package specification with source detection}
\usage{
.parse_package_spec(spec)
}
\arguments{
\item{spec}{Character or list describing the package}
}
\value{
List with normalized components (name, source, version, repo, ref, auto_attach)
}
\description{
Parses package specifications that may include explicit sources, version pins,
or GitHub/Bioconductor references. Supports both scalar strings and list-style
entries from \code{settings.yml}.
}
\details{
Examples:
\itemize{
\item "dplyr" -> list(name = "dplyr", source = "cran")
\item "dplyr@1.1.0" -> list(name = "dplyr", version = "1.1.0", source = "cran")
\item "tidyverse/dplyr@main" -> list(name = "dplyr", repo = "tidyverse/dplyr", ref = "main", source = "github")
\item list(name = "DESeq2", source = "bioc") -> list(name = "DESeq2", source = "bioc")
}
}
\keyword{internal}
