% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailtyCmprsk.R
\name{frailtyCmprsk}
\alias{frailtyCmprsk}
\title{Fit a Weibull Competing Risks Model with Optional Shared Frailty}
\usage{
frailtyCmprsk(formulas, data, maxit = 300,
init.B, init.Theta, init.hazard.weib,
LIMparam = 1e-3, LIMlogl = 1e-3, LIMderiv = 1e-3,
x0, print.info = FALSE, print.result = TRUE,
partialH, blinding = TRUE)
}
\arguments{
\item{formulas}{A list of formula objects. The first formula must include a 
response on the left-hand side of a \code{~} operator. The response must be a
survival object as returned by the \code{Surv} function (e.g., \code{survival::Surv}).
The argument \code{type = "mstate"} must be specified within the
\code{Surv} function. The status indicator in the \code{Surv} object should be:
0 for right-censoring, 1 for the first competing event, 2 for the second, ..., and \code{k} for the
\code{k}th competing event.
Covariates for the transition from 0 to 1 are specified on the right-hand side (RHS) of the first formula.
The remaining elements of the list should be one-sided formulas (e.g., \code{~ var1 + var2}),
used only to specify the covariates. The second formula corresponds to the transition 0 -> 2,
the third to 0 -> 3, and so on, up to the \code{k}th formula for transition 0 -> \code{k}.
Left-truncation is supported and should be specified using the three-argument
\code{Surv(time1, time2, status)} notation.
Shared frailty can be specified via \code{cluster(group_variable)} on the RHS of the first formula only.
It should not be included in the other formulas.}

\item{data}{A \code{data.frame} containing the variables named in \code{formulas}.}

\item{maxit}{Maximum number of iterations for the Marquardt optimization algorithm.
Default is 300.}

\item{init.B}{Optional. A vector of initial values for the regression coefficients.
It should contain the coefficients for each transition from 0->1, ..., up to 0->\code{k}
(i.e., \eqn{\beta_1}, \eqn{\beta_2}, ..., \eqn{\beta_k}), concatenated in order.
The total length must match the total number of covariates specified across all formulas.
If omitted, the regression coefficients are initialized from default values. 
These defaults are obtained by fitting \code{k} independent Weibull proportional 
hazards models (without frailty), one for each transition.}

\item{init.Theta}{Optional. Initial value for the frailty variance \eqn{\theta}.
Default is 0.1. This parameter is only used if \code{cluster()} is present
in \code{formulas}.}

\item{init.hazard.weib}{Optional. A vector of initial values for the Weibull baseline
hazard parameters. It must be of length \code{2 * k}, with the values ordered as:
scale(0->1), shape(0->1), scale(0->2), shape(0->2), ..., scale(0->k), shape(0->k).
If omitted, the baseline hazard parameters are initialized from default values. 
These defaults are obtained by fitting \code{k} independent Weibull proportional 
hazards models (without frailty), one for each transition.}

\item{LIMparam}{Convergence threshold for the parameters based on the maximum
absolute difference between successive iterations (\eqn{10^{-3}} by default).}

\item{LIMlogl}{Convergence threshold for the log-likelihood based on the absolute
difference between successive iterations (\eqn{10^{-3}} by default).}

\item{LIMderiv}{Convergence threshold based on the relative distance to the optimum
(related to gradient and Hessian) (\eqn{10^{-3}} by default). See Details.}

\item{x0}{Optional. A list of numeric vectors, where each vector specifies the time points 
at which to compute the baseline hazard and survival functions for a given transition. 
The order must follow the transitions: 0->1, 0->2, ..., 0->k. If not provided, defaults to 
a list where each element is a sequence of 99 time points from 0 to the maximum observed 
time for the corresponding transition.}

\item{print.info}{Logical. If \code{TRUE}, prints information at each iteration
of the optimization algorithm. Default is \code{FALSE}.}

\item{print.result}{Logical. If \code{TRUE}, prints a formatted summary of the
results. Default is \code{TRUE}.}

\item{partialH}{Optional. Integer vector specifying the indices of parameters to
exclude from the Hessian matrix when calculating the relative distance
convergence criterion (\code{LIMderiv}). This is only considered if the first
two criteria (\code{LIMparam}, \code{LIMlogl}) are met and the full Hessian
is problematic (e.g., not invertible). Default is \code{NULL}.}

\item{blinding}{Logical. If \code{TRUE}, the algorithm attempts to continue even
if the log-likelihood calculation produces non-finite values (e.g., \code{Inf},
\code{NaN}) at some iteration. Setting to \code{FALSE} may cause the algorithm
to stop earlier in such cases. Default is \code{TRUE}.}
}
\value{
An object of class 'frailtyCmprsk' containing:
\describe{
  \item{b}{Vector of the estimated parameters. Order is:
  (scale(0->1), shape(0->1), scale(0->2), shape(0->2),
   ..., scale(0->k), shape(0->k),\eqn{\hat {\theta}} (if frailty), \eqn{\hat{\beta}_1}, \eqn{\hat{\beta}_2},...,\eqn{\hat{\beta}_k}).}
  \item{call}{The matched function call.}
  \item{coef}{Vector of estimated regression coefficients.}
  \item{loglik}{The marginal log-likelihood value at the final parameter estimates.}
  \item{grad}{Gradient vector of the log-likelihood at the final parameter estimates.}
  \item{n}{The number of observations used in the fit.}
  \item{n.events}{Vector containing the number of observed events: count for 0->1, count for 0->2,..., count for 0->k, count for censoring.}
  \item{n.iter}{Number of iterations.}
  \item{vcov}{Variance-covariance matrix for the parameters listed in \code{b}.}
  \item{npar}{Total number of estimated parameters.}
  \item{nvar}{Total number of regression coefficients.}
  \item{shape.weib}{Vector of estimated Weibull baseline shape parameters (shape(0->1),shape(0->2),...,shape(0->k)).}
  \item{scale.weib}{Vector of estimated Weibull baseline scale parameters (scale(0->1),scale(0->2),...,scale(0->k)).}
  \item{crit}{Convergence status code: 1=converged, 2=maximum iterations reached, 3=converged using partial Hessian, 4=the algorithm encountered a problem in the loglikelihood computation.}
  \item{Frailty}{Logical. \code{TRUE} if a model with shared frailty (\code{cluster(.)}) was fitted.}
  \item{beta_p.value}{Vector of p-values from Wald tests for the regression coefficients in \code{coef}.}
  \item{AIC}{Akaike Information Criterion, calculated as \eqn{AIC=\frac{1}{n}(np - l(.))}, where np is the number of parameters and l is the log-likelihood.}
  \item{x0}{List of numeric vectors, where each vector contains the time points used for calculating the baseline functions for each transition.}
  \item{lam0}{List of matrices, where each matrix contains baseline hazard estimates and 95\% confidence intervals at the corresponding time points in \code{x0}, for each transition.}
  \item{surv0}{List of matrices, where each matrix contains baseline survival estimates and 95\% confidence intervals at the corresponding time points in \code{x0}, for each transition.}
  \item{medians}{List of matrices, where each matrix contains the estimated median baseline survival time and its 95\% confidence interval for each transition.}
  \item{linear.pred}{List of numeric vectors, where each vector contains to the linear predictors for transition 0->l (\eqn{l=1,...,k}). 
        For non-frailty models, each element is of the form \eqn{\hat{\beta}_l^{t}X_l}. 
        For frailty models, it includes the estimated log-frailty: \eqn{\hat{\beta}_l^{t}X_l + \log(\hat{\omega}_i)}.}
  \item{names.factor}{List of character vectors, where each vector contains the factor covariates included in the model for the corresponding transition.}
  \item{global_chisq}{List of numeric vectors, where each vector contains the chi-squared statistics from global Wald tests for factor variables for the corresponding transition.}
  \item{dof_chisq}{List of integer vectors, where each vector contains the degrees of freedom for the global Wald tests for the corresponding transition.}
  \item{p.global_chisq}{List of numeric vectors, where each vector contains the p-values for the global Wald tests for the corresponding transition.}
  \item{global_chisq.test}{Binary vector of length k indicating whether any global factor tests were performed for each transition.}
}
If \code{Frailty} is \code{TRUE}, the following components related to frailty are also included:
\describe{
  \item{groups}{The number of unique groups specified by \code{cluster(.)}.}
  \item{theta}{The estimated variance (\eqn{\hat{\theta}}) of the Gamma frailty distribution.}
  \item{theta_p.value}{The p-value from a Wald test for the null hypothesis \eqn{H_0: \theta=0}.}
  \item{VarTheta}{The estimated variance of the frailty variance estimator: \eqn{\hat{Var}(\hat{\theta})}.}
  \item{frailty.pred}{Vector containing the empirical Bayes predictions of the frailty term for each group.}
  \item{frailty.var}{Vector containing the variances of the empirical Bayes frailty predictions.}
  \item{frailty.sd}{Vector containing the standard errors of the empirical Bayes frailty predictions.}
}
}
\description{
Fit a Weibull competing risks model with shared gamma frailty between
all transitions (0->1,0->2,...,0->k). Handles left-truncated and right-censored data.
The model considers transitions from an initial state (0) to (k) competing
absorbing states.

\if{html}{
\figure{CMPRSKSCHEME.png}{options: width="329"}
}

\if{latex}{
\figure{CMPRSKSCHEME.png}{options: width=8.7cm}
}
}
\details{
Let \eqn{T} be the time to event and \eqn{L \in \{1,2,...,k\}}  the indicator of
the cause of the event.

The cause-specific hazard rate for cause \eqn{l \in \{1,2,...,k\}} is:
\deqn{
  \lambda_{l}(t) = \lim_{\Delta t \to 0^+} \frac{\mathbb{P}(t \leq T \leq t + \Delta t, L=l \mid T \geq t)}{\Delta t}
}

A proportional hazards model with a shared frailty term \eqn{\omega_i} is assumed
for each transition within group \eqn{i}. For the \eqn{j^{th}} subject
(\eqn{j=1,...,n_i}) in the \eqn{i^{th}} group (\eqn{i=1,...,G}), the \eqn{l^{th}}
(\eqn{l=1,...,k})  transition intensity is defined as follows:

\deqn{
  \lambda_{l}^{ij}(t |\omega_i,X_{l}^{ij}) = \lambda_{0l}(t) \omega_i \exp(\beta_l^{T} X_{l}^{ij})
}
where \eqn{\omega_i \sim\Gamma(\frac{1}{\theta},\frac{1}{\theta})} with
\eqn{\bold{E}(\omega_i)=1} and \eqn{\bold{Var}(\omega_i)=\theta}.

\eqn{\omega_i} is the frailty term for the \eqn{i^{th}} group.
For subject-specific frailties, use \code{cluster(id)} where id is unique (\eqn{n_i=1}).
\eqn{\beta_l} (\eqn{l=1,...,k}) is the vector 
of time fixed regression coefficients for the transition 0->l.
\eqn{X_{l}^{ij}} (\eqn{l=1,...,k}) is the vector 
of time fixed covariates for the \eqn{j^{th}} subject in the \eqn{i^{th}} group for the 
transition 0->l.
\eqn{\lambda_{0l}(.)} (\eqn{l=1,...,k}) is the 
baseline hazard function for the transition 0->l.

The Weibull baseline hazard parameterization is:
\deqn{\lambda(t) = \frac{\gamma}{\lambda^\gamma} \cdot t^{\gamma - 1}} 
where \eqn{\lambda} is the scale parameter and \eqn{\gamma} the shape parameter
}
\note{
The optimization uses the robust Marquardt algorithm (Marquardt, 1963),
combining Newton-Raphson and steepest descent steps. Iterations stop when
criteria \code{LIMparam}, \code{LIMlogl}, and \code{LIMderiv} are all met. 
Confidence bands for the baseline hazard and baseline survival functions were 
computed using a Monte Carlo simulation approach based on the estimated Weibull 
parameters. A sample of size 1000 was drawn from the joint distribution of the 
shape and scale parameters. For each sampled parameter set, the baseline functions 
were evaluated over the time grid defined by the vector \code{x0}. Pointwise 95% 
confidence bands were then obtained by computing the 2.5th and 97.5th percentiles 
of the simulated values at each time point for each baseline function.
}
\examples{
\donttest{


data(CPRSKbmtcrr)

##-- Weibull competing risks model with 
##   group frailty shared between transitions --##

ModCmprsk_Group <- frailtyCmprsk(
  formulas = list(
    Surv(observed_time, Status, type = "mstate") ~ cluster(group) + Sex,
    ~ Sex
  ),
  data        = CPRSKbmtcrr,
  print.info  = FALSE,
  maxit       = 100
)

##-- Weibull competing risks model with subject-specific 
##   frailty shared between transitions --##

ModCmprsk_Subject <- frailtyCmprsk(
  formulas = list(
    Surv(observed_time, Status, type = "mstate") ~ cluster(id) + Sex,
    ~ Sex
  ),
  data        = CPRSKbmtcrr,
  print.info  = FALSE,
  maxit       = 100
)

##--- Simple Weibull competing risks model with left truncation ---##

ModCmprsk_LeftTrunc <- frailtyCmprsk(
  formulas = list(
    Surv(Age, observed_time, Status, type = "mstate") ~ Source,
    ~ Sex
  ),
  data       = CPRSKbmtcrr,
  print.info = FALSE
)

##--- Simple Weibull competing risks model with a factor and 
##    no covariates for the first competing event (left truncation) ---##

ModCmprsk_Factor_LeftTrunc <- frailtyCmprsk(
  formulas = list(
    Surv(Age, observed_time, Status, type = "mstate") ~ Source,
    ~ factor(Phase)
  ),
  data       = CPRSKbmtcrr,
  print.info = FALSE
)  }

}
\references{
Marquardt, D. W. (1963). An algorithm for least-squares estimation of nonlinear
parameters. \emph{SIAM Journal on Applied Mathematics}, 11(2), 431-441.

Liquet, B., Timsit, J. F., & Rondeau, V. (2012). Investigating hospital
heterogeneity with a multi-state frailty model: application to nosocomial
pneumonia disease in intensive care units. \emph{BMC Medical Research
Methodology}, 12(1), 1-14.
}
