% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_forcis_columns.R
\name{select_forcis_columns}
\alias{select_forcis_columns}
\title{Select columns in FORCIS data}
\usage{
select_forcis_columns(data, cols = NULL)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}

\item{cols}{a \code{character} vector of column names to keep in addition to the
required ones (see \code{\link[=get_required_columns]{get_required_columns()}}) and to the taxa columns. Can
be \code{NULL} (default).}
}
\value{
A \code{tibble}.
}
\description{
Selects columns in FORCIS data. Because FORCIS data contains more than 100
columns, this function can be used to lighten the \code{data.frame} to easily
handle it and to speed up some computations.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Dimensions of the data.frame ----
dim(net_data)

# Select a taxonomy ----
net_data <- select_taxonomy(net_data, taxonomy = "VT")

# Dimensions of the data.frame ----
dim(net_data)

# Select only required columns (and taxa) ----
net_data <- select_forcis_columns(net_data)

# Dimensions of the data.frame ----
dim(net_data)
}
