% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_species.R
\name{filter_by_species}
\alias{filter_by_species}
\title{Filter FORCIS data by species}
\usage{
filter_by_species(data, species)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}

\item{species}{a \code{character} vector listing species of interest.}
}
\value{
A \code{tibble} containing a subset of \code{data}.
}
\description{
Filters FORCIS data by a species list.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Select a taxonomy ----
net_data <- select_taxonomy(net_data, taxonomy = "VT")

# Select only required columns (and taxa) ----
net_data <- select_forcis_columns(net_data)

# Dimensions of the data.frame ----
dim(net_data)

# Get species names ----
get_species_names(net_data)

# Select records for three species ----
net_data_sub <- filter_by_species(data    = net_data,
                                  species = c("g_inflata_VT",
                                              "g_elongatus_VT",
                                              "g_glutinata_VT"))

# Dimensions of the data.frame ----
dim(net_data_sub)

# Get species names ----
get_species_names(net_data_sub)
}
