% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_3d.R
\name{fm_mesh_3d}
\alias{fm_mesh_3d}
\alias{fm_delaunay_3d}
\title{Construct a 3D tetrahedralisation}
\usage{
fm_mesh_3d(loc = NULL, tv = NULL, ...)

fm_delaunay_3d(loc, ...)
}
\arguments{
\item{loc}{Input coordinates that should be part of the mesh. Can be a
matrix, \code{sf}, \code{sfc}, \code{SpatialPoints}, or other object supported by
\code{\link[=fm_unify_coords]{fm_unify_coords()}}.}

\item{tv}{Tetrahedron indices, as a N-by-4 index vector into \code{loc}}

\item{...}{Currently unused.}
}
\value{
An \code{fm_mesh_3d} object
}
\description{
Constructs a 3D tetrahedralisation object.
}
\section{Functions}{
\itemize{
\item \code{fm_delaunay_3d()}: Construct a plain Delaunay triangulation in 3D.
Requires the \code{geometry} package.

}}
\examples{
(m <- fm_mesh_3d(
  matrix(c(1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0), 4, 3, byrow = TRUE),
  matrix(c(1, 2, 3, 4), 1, 4, byrow = TRUE)
))
\dontshow{if (requireNamespace("geometry", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
(m <- fm_delaunay_3d(matrix(rnorm(30), 10, 3)))
\dontshow{\}) # examplesIf}
}
