% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_gauge_data.R
\name{bind_gauge_data}
\alias{bind_gauge_data}
\title{Bind gauge data}
\usage{
bind_gauge_data(
  .,
  data = NULL,
  name = NULL,
  value = NULL,
  name_input_format = NULL,
  name_output_format = NULL,
  value_input_format = NULL,
  value_output_format = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{name}{Name}

\item{value}{Value. One or more columns of numbers. Flourish type hint: columns}

\item{name_input_format}{Formats/parses dates, strings, and numbers for the name column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{name_output_format}{Formats/parses dates, strings, and numbers for the name column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{value_input_format}{Formats/parses dates, strings, and numbers for the value column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{value_output_format}{Formats/parses dates, strings, and numbers for the value column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}
}
\value{
A Flourish chart
}
\description{
Bind gauge data
}
\examples{
try(
  flourish(chart_type = "gauge", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_gauge_data(gapminder)
)
}
