% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_bubble_chart_data.R
\name{bind_bubble_chart_data}
\alias{bind_bubble_chart_data}
\title{Bind bubble chart data}
\usage{
bind_bubble_chart_data(
  .,
  data = NULL,
  label = NULL,
  color = NULL,
  size = NULL,
  axis_values = NULL,
  image = NULL,
  metadata = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{label}{Label}

\item{color}{Color by. Used to color the bubbles. Flourish type hint: column}

\item{size}{Size by. Value for bubble size. Flourish type hint: column}

\item{axis_values}{Axis values. Values used to plot the bubbles when the bubbles are aligned on an axis. Flourish type hint: column}

\item{image}{Image. Images for bubbles. Add an image URL or right-click on a cell to upload an image. Flourish type hint: column}

\item{metadata}{Info for popups. One or more columns of information (text, image URLs, embedded charts etc) to include in custom popups and panels Flourish type hint: columns}
}
\value{
A Flourish chart
}
\description{
Bind bubble chart data
}
\examples{
try(
  flourish(chart_type = "bubble", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_bubble_chart_data(gapminder)
)
}
