% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-preprocess-grid.R
\name{DoU_preprocess_grid}
\alias{DoU_preprocess_grid}
\title{Preprocess the data for the DEGURBA grid cell classification}
\usage{
DoU_preprocess_grid(
  directory,
  filenames = c("BUILT_S.tif", "POP.tif", "LAND.tif"),
  rescale_land = TRUE,
  rescale_built = TRUE
)
}
\arguments{
\item{directory}{character. Path to the directory where the three input grids are saved (for example generated by the function \code{\link[=download_GHSLdata]{download_GHSLdata()}})}

\item{filenames}{vector of length 3 with the filenames of the built-up area, population and land grid}

\item{rescale_land}{logical. Whether to rescale the values of the land grid (see details)}

\item{rescale_built}{logical. Whether to rescale the values of the built-up area grid (see details)}
}
\value{
named listed with the required data to execute the grid cell classification procedure. The list contains following elements:
\itemize{
\item \code{built}: built-up area grid
\item \code{pop}: population grid
\item \code{land}: land grid
\item \code{pop_per_land}: population per area of permanent land
\item \code{built_per_land}: built-up area per permanent land
\item \code{metadata_BUILT_S}: the metadata of the built-up area grid
\item \code{metadata_POP}: the metadata of the population grid
\item \code{metadata_LAND}: the metadata of the land grid.
}
}
\description{
The grid cell classification of the Degree of Urbanisation requires three different inputs:
\itemize{
\item a built-up area grid
\item a population grid
\item a land grid
}

The function rescales the built-up area and land grid if necessary (see details) and computes the population and built-up area per permanent land by dividing the respective grids by the land layer.
}
\details{
The values of the land grid and built-up area grid should range from \code{0} to \code{1}, representing the proportion of permanent land and built-up area respectively. However, the grid values of the GHSL are standard in m². With a cell size of 1 km², the values thus range from \code{0} to \verb{1 000 000}. The two grids can be rescaled by setting \code{rescale_land=TRUE} and/or \code{rescale_built=TRUE} respectively.
}
