% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_plot.R
\name{plot.fuzzy_lm}
\alias{plot.fuzzy_lm}
\title{Plot Fuzzy Regression Results}
\usage{
\method{plot}{fuzzy_lm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{fuzzy_lm}.}

\item{...}{Additional arguments passed to the method, including:
\itemize{
\item \code{X_fuzzy}: A list of fuzzified predictor variables.
\item \code{Y_fuzzy}: A list of fuzzified outcome variables.
}}
}
\value{
A \code{ggplot2} object for simple regression or a \code{plotly} object for multiple regression.
}
\description{
Visualizes the results of a fuzzy regression model. For simple regression
(1 predictor), it generates a 2D plot with fuzzy intervals and regression lines.
For multiple regression (2 predictors), it generates a 3D plot with cubes representing
fuzzy intervals and a regression plane.
}
\examples{
# Example 1: Simple Regression
# See above for setup example

# Example 2: Multiple Regression
set.seed(123)
n <- 100
x1_crisp <- runif(n, 5, 15)
x2_crisp <- runif(n, 10, 20)
beta <- c(3, 1.5, -0.8)
y_crisp <- beta[1] + beta[2] * x1_crisp + beta[3] * x2_crisp + rnorm(n, mean = 0, sd = 2)

X_fuzzy <- fuzzify_crisp_matrix(cbind(x1_crisp, x2_crisp), spread = 0.5)
Y_fuzzy <- fuzzify_crisp_vector(y_crisp, spread = 1.0)
object <- fuzzy_lm(X_fuzzy, Y_fuzzy, p = 2)
\donttest{
plot(object, X_fuzzy = X_fuzzy, Y_fuzzy = Y_fuzzy)
}
}
