% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzification.R
\name{fuzzify_crisp_vector}
\alias{fuzzify_crisp_vector}
\title{Fuzzify a vector of crisp values}
\usage{
fuzzify_crisp_vector(crisp_vector, spread = 1, var_name = "Outcome")
}
\arguments{
\item{crisp_vector}{A numeric vector to be fuzzified.}

\item{spread}{A non-negative numeric value specifying the spread for the fuzzy membership function.}

\item{var_name}{Optional. A character string specifying a common name for all fuzzified values. Default is \code{NULL}.}
}
\value{
A list of fuzzified values, where each value is represented as a list with components \code{l}, \code{x}, and \code{r}.
}
\description{
Converts a numeric vector into a list of fuzzified values using a triangular fuzzy membership function.
}
\examples{
crisp_vector <- c(10, 20, 30)
fuzzify_crisp_vector(crisp_vector, spread = 1, var_name = "Variable")
}
