% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_predict.R
\name{ff_auc}
\alias{ff_auc}
\title{Function for AUC estimation}
\usage{
ff_auc(params, x_new, curve, fixed_params = NA, n_points = 1000)
}
\arguments{
\item{params}{A vector of parameter values.}

\item{x_new}{A vector of size 2 given the interval to calculate the area under.}

\item{curve}{A string. The name of the function used for curve fitting.}

\item{fixed_params}{A vector of fixed parameter values. NA by default.}

\item{n_points}{Numeric value giving the number of points to use in the trapezoidal method.}
}
\value{
Area under the fitted curve.
}
\description{
Function for AUC estimation
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
# AUC Prediction
predict(mod_1, x = c(0, 108), type = "auc", id = 2)
}
\keyword{internal}
