% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covselec.R
\name{covselec}
\alias{covselec}
\title{covselec}
\usage{
covselec(
  data,
  time_cols,
  status_cols,
  covariate_range,
  alphas,
  lambdas,
  method = "lasso",
  p_cut = 0.2,
  verbose = TRUE
)
}
\arguments{
\item{data}{Multi state dataset with multiple state and time column in the data}

\item{time_cols}{time-to-event columns for each state in a MSM}

\item{status_cols}{status columns for corresponding states in a MSM}

\item{covariate_range}{range of high-dimensional biomarkers in the MSM dataset}

\item{alphas}{penalty parameter for lasso type penalty}

\item{lambdas}{penalty parameter for fused type penalty}

\item{method}{method to be selected for covariate selction either "lasso" or "fused"}

\item{p_cut}{association between variables}

\item{verbose}{Logical indicating whether to print progress messages}
}
\value{
list containing selected biomarkers for each state
}
\description{
This function is used for state-wise weighted biomarker selection for both lasso and fused type penalty
and is applicable for a multi-state model encompassing finite number of states and transitions.
}
\details{
This function deals with biomarker selection for each state of a multi-state model each
phase involves selecting significant biomarkers for that state from two sets: one comprising covariates
from the preceding state, and another consisting of all covariates from the current state that were
previously unselected.If the total number of biomarkers is referred to as the overall count, and each
state in a multi-state model has its own number of selected biomarkers, then in a model with four states,
the number of selected biomarkers for the fourth state is determined using a weighted combination.
Specifically, it depends on the number of biomarkers selected in the third state, a modified set from the
second state, another modified set from the first state
}
\examples{
##
set.seed(123)
covselec(data= highDmsm,time_cols = c("state1", "state2","state3"),
status_cols = c("status1", "status2","status3"),
covariate_range = 8:107,alphas=c(0.40,0.45,0.60),
lambdas = c(0.1,0.15,0.20),method = "lasso", p_cut = 0.2,verbose = TRUE)
##
}
\author{
Atanu Bhattacharjee,Gajendra Kumar Vishwakarma,Abhipsa Tripathy
}
