% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_column_names.R
\name{fix_column_names}
\alias{fix_column_names}
\title{Fix Column Names}
\usage{
fix_column_names(data)
}
\arguments{
\item{data}{A data frame with improperly formatted column names.}
}
\value{
The modified data frame with fixed column names.
}
\description{
This function removes "X." or "X" from the beginning of column names and replaces any "." with "_". It also removes leading/trailing symbols and spaces, and ensures that there is only one underscore between two words. If there are duplicate column names, it appends a number to each duplicate column name to make it unique.
}
\examples{
my_data <- data.frame(" Col1" = c(1, 2, 3), "Col.2" = c(4, 5, 6), check.names = FALSE)
fix_column_names(my_data)

}
