% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCOV.R
\name{vcov_hetero}
\alias{vcov_hetero}
\title{Heteroskedasticity-Robust VCOV}
\usage{
vcov_hetero(
  x,
  type = "hc1",
  exact = TRUE,
  boot.size = NULL,
  ssc = NULL,
  vcov_fix = TRUE
)
}
\arguments{
\item{x}{A \code{fixest} object.}

\item{type}{A string scalar. Either "HC1"/"HC2"/"HC3"}

\item{exact}{Logical scalar, default is \code{TRUE}. Whether the diagonals of the projection matrix should be calculated exactly. If \code{FALSE}, then it will be approximated using a JLA algorithm. See details. Unless you have a very large number of observations, it is recommended to keep the default value.}

\item{boot.size}{Integer scalar or \code{NULL}, default is 1000. This is only used when \code{exact == FALSE}. This determines the number of bootstrap samples used to estimate the projection matrix. If equal to \code{NULL}, it falls back to the default value of 1000.}

\item{ssc}{An object returned by the function \code{\link{ssc}}. It specifies how to perform the small
sample correction.}

\item{vcov_fix}{Logical scalar, default is \code{FALSE}. If the VCOV ends up not being
positive definite, whether to "fix" it using an eigenvalue decomposition
(a la Cameron, Gelbach & Miller 2011).
Since the VCOV should be PSD asymptotically, this might be a sign of a problem
with using the asymptotic approximation (e.g. too few units in clusters).
If a problem is detected, the function will print a message to inform you.}
}
\value{
If the first argument is a \code{fixest} object, then a VCOV is returned (i.e. a symmetric matrix).

If the first argument is not a \code{fixest} object, then a) implicitly the arguments are shifted to the left (i.e. \code{vcov_hetero("HC3")} is equivalent to \code{vcov_hetero(type = "HC3")} and b) a VCOV-\emph{request} is returned and NOT a VCOV. That VCOV-request can then be used in the argument \code{vcov} of various \code{fixest} functions (e.g. \code{\link{vcov.fixest}} or even in the estimation calls).
}
\description{
Computes the heteroskedasticity-robust VCOV of \code{fixest} objects.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")

est = feols(y ~ x1 | species, base)

vcov_hetero(est, "hc1")
vcov_hetero(est, "hc2", ssc = ssc(K.adj = FALSE))
vcov_hetero(est, "hc3", ssc = ssc(K.adj = FALSE))

# Using approximate hatvalues
vcov_hetero(est, "hc3", exact = FALSE, boot.size = 500)

}
\references{
MacKinnon, J. G. (2012). "Thirty years of heteroscedasticity-robust inference." Recent Advances and Future Directions in Causality, Prediction, and Specification Analysis, pp. 437--461. https://doi.org/10.1007/978-1-4614-1653-1_17
}
\author{
Laurent Berge and Kyle Butts
}
