% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{combineFiles}
\alias{combineFiles}
\title{Combine the X and Y intensity scores and the assigned dosage in one file}
\usage{
combineFiles(XYdata, scores, controls=character(0))
}
\arguments{
\item{XYdata}{data.frame with (at least) columns MarkerName,
SampleName, X, Y (if present, R and ratio are also copied)}

\item{scores}{data.frame with scores produced by the
fitMarkers function of package fitPoly. It has columns MarkerName
and SampleName that are subsets of MarkerName and SampleName in the XYdata,
and at least a column geno}

\item{controls}{a character vector of sample names. The geno (dosage)
value of these samples is set to NA}
}
\value{
a dataframe with columns MarkerName, SampleName, X, Y (and R and
ratio if these columns were present in XYdata), and geno, with all markers
and samples from XYdata. The value of geno is set to NA for all MarkerName /
sample combinations not present in scores, and for all samples in controls.
}
\description{
This function combines the X and Y intensity values from the
fitPoly input with the geno (assigned dosage) from the fitPoly scores
output. Useful for producing XY scatterplots with samples colored
according to the assigned dosage.
}
