% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfqResample.R
\name{lfqResample}
\alias{lfqResample}
\title{Resampling of length-frequency data}
\usage{
lfqResample(lfq)
}
\arguments{
\item{lfq}{A length frequency object of the class \code{lfq}.}
}
\value{
A resampled version of the \code{lfq} class dataset.
}
\description{
This function resamples the \code{lfq} data by sampling dates.
Sampling is done in a non-parametric way following the relative frequencies
of the original data, allowing for individual counts to be selected more than
once (i.e. \code{replace = TRUE} in \link[base]{sample}), and resulting in
total counts (by sample) equal to the original data.
}
\examples{
# Load data
data("alba", package = "TropFishR")

# Resample lfq data
alba_p <- lfqResample(lfq = alba)

# Side-by-side plot
op <- par(no.readonly = TRUE)
par(mfcol = c(2, 1), mar = c(4, 4, 2, 1))

# Original
plot(x = TropFishR::lfqRestructure(alba), Fname = "rcounts")
mtext("original", side=3, line=0.25)

# Resampled
plot(TropFishR::lfqRestructure(alba_p), Fname = "rcounts")
mtext("resampled", side=3, line=0.25)

par(op)
}
