% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fidofit_methods.R
\name{pibble_tidy_samples}
\alias{pibble_tidy_samples}
\title{Convert pibble samples of Eta Lambda and Sigma to tidy format}
\usage{
pibble_tidy_samples(m, use_names = FALSE, as_factor = FALSE)
}
\arguments{
\item{m}{an object of class pibblefit}

\item{use_names}{should dimension indices be replaced by
dimension names if provided in data used to fit pibble model.}

\item{as_factor}{if use_names should names be returned as factor?}
}
\value{
tibble
}
\description{
Combines them all into a single tibble, see example for formatting and 
column headers. Primarily designed to be used by 
\code{\link{summary.pibblefit}}.
}
\examples{
sim <- pibble_sim()
fit <- pibble(sim$Y, sim$X)
fit_tidy <- pibble_tidy_samples(fit, use_names=TRUE)
head(fit_tidy)
}
