% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_parameters.R
\name{reset_radii}
\alias{reset_radii}
\title{Reset Radii Values}
\usage{
reset_radii()
}
\description{
This function reloads the 'OS' default atomic radii values.
}
\examples{
\donttest{
library(fibos)
fibos_config()
#Loads the radius values that have been configured for code execution.
radii = get_radii()
#Displays the first three lines.
radii |> utils::head(3) |> print()
#Modifies the value of a specific radius.
radii$RAY[1] = 2.15
#Sets the radius value from a tibble.
set_radii(radii)
#Displays the first three lines.
get_radii() |> utils::head(3) |> print()
#Loads the default radius values.
reset_radii()
#Displays the first three lines.
get_radii() |> utils::head(3) |> print()
}
}
\seealso{
\code{\link[=get_radii]{get_radii()}}

\code{\link[=set_radii]{set_radii()}}
}
\author{
Carlos Henrique da Silveira (carlos.silveira@unifei.edu.br)

Herson Hebert Mendes Soares (hersonhebert@hotmail.com)

Joao Paulo Roquim Romanelli (joaoromanelli@unifei.edu.br)

Patrick Fleming (Pat.Fleming@jhu.edu)
}
