% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferenceDataObjectTime.R
\name{inferenceDataObjectTimeBuilder}
\alias{inferenceDataObjectTimeBuilder}
\title{Constructor for inferenceDataObjectTime class}
\usage{
inferenceDataObjectTimeBuilder(test = NULL, 
interval = NULL, 
type = 'w', 
component = 'parametric',
dim = NULL, 
n_cov = NULL,
locations = NULL,
locations_indices = NULL,
locations_by_nodes = F,
time_locations = NULL,
coeff = NULL, 
beta0 = NULL, 
f0 = NULL,
f_var = F,
level = 0.95,
n_flip = 1000)
}
\arguments{
\item{test}{A string defining the type of test to be performed. Multiple tests can be required. In this case the length of the list needs to be coherent with the ones of \code{type},
\code{component} and \code{interval}. The default is NULL, and can take values:
\describe{
\item{'oat'}{: one-at-the-time tests, available only when \code{component} is 'parametric'.}
\item{'sim'}{: simultaneous tests.}
\item{'none'}{: no test required. \code{interval} must be set.}
}}

\item{interval}{A string defining the type of confidence intervals to be computed. Multiple intervals can be required. In this case the length of the list needs to be coherent with the ones of \code{type},
\code{component} and \code{test}. The default is NULL, and can take values:
\describe{
\item{'oat'}{: one-at-the-time intervals.}
\item{'sim'}{: simultaneous intervals, available only when \code{component} is 'parametric' and no sign-flipping approaches are required.}
\item{'bonf'}{: Bonferroni intervals, available only when \code{component} is 'parametric'}
\item{'none'}{: no interval required. \code{test} must be set.}
}}

\item{type}{A list of strings defining the type of implementation for the inferential analysis. The possible values are:
\describe{
\item{'w'}{: Wald parametric approach (default).}
\item{'s'}{: Speckman parametric approach, available only when \code{component} is 'parametric'.}
\item{'esf'}{: eigen-sign-flip nonparametric approach, available only when \code{component} is 'parametric'.}
\item{'enh-esf'}{: enhanced-eigen-sign-flip nonparametric approach, available only when \code{component} is 'parametric'.}
}}

\item{component}{A list of strings defining on which model component inference has to be performed. It can take values 'parametric' (default), 'nonparametric' or 'both'.}

\item{dim}{Dimension of the problem, defaulted to NULL. It can take value 2 or 3 corresponding to 1.5D/2D or 2.5D/3D problems (Must be set by the user)}

\item{n_cov}{Number of the covariates, defaulted to NULL. (Must be set by the user)}

\item{locations}{A matrix of the locations of interest when testing the nonparametric component f, defaulted to NULL.}

\item{locations_indices}{A vector of indices indicating the locations to be considered among the observed ones for nonparametric inference, defaulted to NULL.
If a vector of indices is provided, then the slot 'locations' is discarded.}

\item{locations_by_nodes}{A logical used to indicate whether the selected locations to perform inference on f are all coinciding with the nodes.}

\item{time_locations}{A vector of times of interest when testing the nonparametric component f, defaulted to NULL. If \code{FLAG_parabolic = TRUE}, \code{time_locations} need to be NULL or to coincide with the time mesh.}

\item{coeff}{A matrix, with \code{n_cov} number of columns, of numeric coefficients representing the linear combinations of the parametric components of the model.
The default is NULL, corresponding to an identity matrix. If at least one sing-flipping approach is required in \code{type}, needs to be an identity matrix.}

\item{beta0}{Vector of real numbers (default NULL). It is used only if the \code{test} parameter is set, and \code{component} is not 'nonparametric'; its length is the number of rows of matrix \code{coeff} if provided. 
If \code{test} is set and \code{beta0} is NULL, will be set to a vector of zeros.}

\item{f0}{A function object representing the expression of the nonparametric component f under the null hypothesis. Taken into account if \code{test} is set and \code{component} is not parametric.
If NULL, the default is the null function, hence a test on the significance of the nonparametric component is carried out.}

\item{f_var}{A logical used to decide whether to estimate the local variance of the nonlinear part of the model.
The possible values are: FALSE (default) and TRUE.}

\item{level}{A vector containing the level of significance used to compute quantiles for confidence intervals, defaulted to 0.95. It is taken into account only if \code{interval} is set.}

\item{n_flip}{Number of flips performed in sign-flipping approaches, defaulted to 1000.}
}
\value{
The output is a well defined \code{\link{inferenceDataObjectTime}}, that can be used as input parameter in the \code{\link{smooth.FEM}} function.
}
\description{
A function that build an \code{\link{inferenceDataObjectTime}}. In the process of construction many checks over the input parameters are carried out so that the output is a well defined object,
that can be used as parameter in \code{\link{smooth.FEM}} or \code{\link{smooth.FEM.time}} functions.
Notice that this constructor ensures well-posedness of the object, but a further check on consistency with the smoothing functions parameters will be carried out.
}
\examples{
obj<-inferenceDataObjectTimeBuilder(test = 'oat', dim = 2, beta0 = rep(1,4), n_cov = 4);
obj2<-inferenceDataObjectTimeBuilder(test = 'sim', dim = 3, component = 'nonparametric', n_cov = 3);
}
