% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_types.r
\name{are_integerish}
\alias{are_integerish}
\alias{are_scalar_integerish}
\alias{are_bare_integerish}
\title{Are vectors integer-like?}
\usage{
are_integerish(..., .n = NULL, .finite = NULL, .all = FALSE)

are_scalar_integerish(..., .n = NULL, .finite = NULL, .all = FALSE)

are_bare_integerish(..., .n = NULL, .finite = NULL, .all = FALSE)
}
\arguments{
\item{...}{Objects to be tested.}

\item{.n}{Expected lengths of the vectors.}

\item{.finite}{Whether all values of the vectors are finite. The
non-finite values are \code{NA}, \code{Inf}, \code{-Inf} and \code{NaN}. Setting this
to something other than \code{NULL} can be expensive because the whole
vector needs to be traversed and checked.}

\item{.all}{If \code{TRUE}, return boolean of whether all arguments returned
\code{TRUE}.}
}
\value{
Named logical, or unnamed boolean if \code{.all} is \code{TRUE}.
}
\description{
Wrappers around \link[rlang:rlang-package]{rlang} type predicates that allow
multiple objects to be passed. The following documentation is adapted
from the rlang \link[rlang:is_integerish]{documentation}:

These predicates check whether R considers a number vector to be
integer-like, according to its own tolerance check (which is in
fact delegated to the C library). This function is not adapted to
data analysis, see the help for \code{\link[base:integer]{base::is.integer()}} for examples
of how to check for whole numbers.

Things to consider when checking for integer-like doubles:
\itemize{
\item This check can be expensive because the whole double vector has
to be traversed and checked.
\item Large double values may be integerish but may still not be
coercible to integer. This is because integers in R only support
values up to \code{2^31 - 1} while numbers stored as double can be
much larger.
}
}
\details{
The optional inputs of \code{.n} and \code{.finite} can be given inputs
that map to the arguments in \code{...}. If a unnamed vector/list, the input must
either be the same length as the number of arguments given to \code{...}, or
length 1: which is then recycled to the number number of arguments
given to \code{...}. Alternatively, a named vector/list can be given, where
the values for matching named elements are passed to the type predicate,
but unmatched names are passed NULL.
}
\examples{
x <- 10L
y <- 10.0
z <- 10.000001

are_integerish(x, y, z, TRUE)

#' # `.all` can be given to test if all inputs
# evaluate to TRUE
are_integerish(x, y, z, TRUE, .all = TRUE)

# scalar inputs to `.n` and `.finite` are
# recycled to number of inputs
are_integerish(x, y, z, TRUE, .n = 2)

# inputs to `.n` and `.finite` matching the
# number of inputs are applied sequentially
are_integerish(x, y, z, TRUE, .n = c(1, 2, 1, 1))

# named inputs to `.n` and `.finite` are applied
# to the matching input names, with the other inputs
# being given NULL
are_integerish(x, y, z, TRUE, .n = c(y = 2, "TRUE" = 1))
}
\seealso{
\link{are_bare_numeric} for testing whether an object is a
base numeric type (a bare double or integer vector).
}
