% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fauna_discrepancies.R
\name{fauna_discrepancies}
\alias{fauna_discrepancies}
\title{Resolve discrepancies between species and subspecies information}
\usage{
fauna_discrepancies(data)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function.}
}
\value{
a data.frame with the discrepancies solved
}
\description{
Resolve discrepancies between species and subspecies information
}
\details{
In the original dataset, discrepancies may exist between species and
subspecies information. An example of a discrepancy is when
species occurs only in one state (e.g., SP), but a subspecies or variety
of the same species occurs in another states (e.g., SP and RJ). This function
rectifies such discrepancies by considering distribution (states and countries)
life form, and habitat. For instance, if a subspecies is recorded in a specific
state, it implies that the species also occurs in that state
}
\examples{
data("fauna_data") #Load fauna e Funga do Brasil data
#Check if discrepancies were solved in the dataset
attr(fauna_data, "solved_discrepancies")
#Solve discrepancies
fauna_solved <- fauna_discrepancies(fauna_data)
#Check if discrepancies were solved in the dataset
attr(fauna_solved, "solved_discrepancies")
}
