% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastCrr.R
\name{fastCrr}
\alias{fastCrr}
\title{Fast Fine-Gray Model Estimation}
\usage{
fastCrr(
  formula,
  data,
  eps = 1e-06,
  max.iter = 1000,
  getBreslowJumps = TRUE,
  standardize = TRUE,
  variance = TRUE,
  var.control = varianceControl(B = 100, useMultipleCores = FALSE),
  returnDataFrame = FALSE
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a Crisk object as returned by the \code{Crisk} function.}

\item{data}{a data.frame in which to interpret the variables named in the formula.}

\item{eps}{Numeric: algorithm stops when the relative change in any coefficient is less than \code{eps} (default is \code{1E-6})}

\item{max.iter}{Numeric: maximum iterations to achieve convergence (default is 1000)}

\item{getBreslowJumps}{Logical: Output jumps in Breslow estimator for the cumulative hazard.}

\item{standardize}{Logical: Standardize design matrix.}

\item{variance}{Logical: Get standard error estimates for parameter estimates via bootstrap.}

\item{var.control}{List of options for variance estimation.}

\item{returnDataFrame}{Logical: Return (ordered) data frame.}
}
\value{
Returns a list of class \code{fcrr}.
\item{coef}{the estimated regression coefficients}
\item{var}{estimated variance-covariance matrix via bootstrap (if \code{variance = TRUE})}
\item{logLik}{log-pseudo likelihood at the estimated regression coefficients}
\item{logLik.null}{log-pseudo likelihood when the regression coefficients are 0}
\item{lrt}{log-pseudo likelihood ratio test statistic for the estimated model vs. the null model.}
\item{iter}{iterations of coordinate descent until convergence}
\item{converged}{logical.}
\item{breslowJump}{Jumps in the Breslow baseline cumulative hazard (used by \code{predict.fcrr})}
\item{uftime}{vector of unique failure (event) times}
\item{isVariance}{logical to return if variance is chosen to be estimated}
\item{df}{returned ordered data frame if \code{returnDataFrame = TRUE}.}
}
\description{
Estimates parameters for the proportional subdistribution hazards model using two-way linear scan approach.
}
\details{
Fits the 'proportional subdistribution hazards' regression model described in Fine and Gray (1999) using a novel two-way linear scan approach.
By default, the \code{Crisk} object will specify which observations are censored (0), the event of interest (1), or competing risks (2).
}
\examples{

library(fastcmprsk)

set.seed(10)
ftime <- rexp(200)
fstatus <- sample(0:2, 200, replace = TRUE)
cov <- matrix(runif(1000), nrow = 200)
dimnames(cov)[[2]] <- c('x1','x2','x3','x4','x5')
fit <- fastCrr(Crisk(ftime, fstatus) ~ cov, variance = FALSE)

# Not run: How to set up multiple cores for boostrapping
# library(doParallel) #  make sure necessary packages are loaded
# myClust <- makeCluster(2)
# registerDoParallel(myClust)
# fit1 <- fastCrr(Crisk(ftime, fstatus) ~ cov, variance = TRUE,
# var.control = varianceControl(B = 100, useMultipleCores = TRUE))
# stopCluster(myClust)



}
\references{
Fine J. and Gray R. (1999) A proportional hazards model for the subdistribution of a competing risk.  \emph{JASA} 94:496-509.

#' Kawaguchi, E.S., Shen J.I., Suchard, M. A., Li, G. (2020) Scalable Algorithms for Large Competing Risks Data, Journal of Computational and Graphical Statistics
}
