% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faraway-package.R
\docType{data}
\name{wcgs}
\alias{wcgs}
\title{Western Collaborative Group Study}
\format{
A data frame with 3154 observations on the following 13 variables.
\describe{ \item{age}{age in years} \item{height}{height in
inches} \item{weight}{weight in pounds} \item{sdp}{systolic
blood pressure in mm Hg} \item{dbp}{diastolic blood pressure in mm
Hg} \item{chol}{Fasting serum cholesterol in mm \%}
\item{behave}{behavior type which is a factor with levels \code{A1}
\code{A2} \code{B3} \code{B4}} \item{cigs}{number of cigarettes
smoked per day} \item{dibep}{behavior type a factor with levels
\code{A} (Agressive) \code{B} (Passive)} \item{chd}{coronary heat
disease developed is a factor with levels \code{no} \code{yes}}
\item{typechd}{type of coronary heart disease is a factor with
levels \code{angina} \code{infdeath} \code{none} \code{silent}}
\item{timechd}{Time of CHD event or end of follow-up}
\item{arcus}{arcus senilis is a factor with levels \code{absent}
\code{present}} }
}
\source{
Statistics for Epidemiology by N. Jewell (2004)
}
\description{
3154 healthy young men aged 39-59 from the San Francisco area were assessed
for their personality type. All were free from coronary heart disease at the
start of the research. Eight and a half years later change in this situation
was recorded.
}
\details{
The WCGS began in 1960 with 3,524 male volunteers who were employed by 11
California companies. Subjects were 39 to 59 years old and free of heart
disease as determined by electrocardiogram. After the initial screening, the
study population dropped to 3,154 and the number of companies to 10 because
of various exclusions. The cohort comprised both blue- and white-collar
employees. At baseline the following information was collected:
socio-demographic including age, education, marital status, income,
occupation; physical and physiological including height, weight, blood
pressure, electrocardiogram, and corneal arcus; biochemical including
cholesterol and lipoprotein fractions; medical and family history and use of
medications; behavioral data including Type A interview, smoking, exercise,
and alcohol use. Later surveys added data on anthropometry, triglycerides,
Jenkins Activity Survey, and caffeine use. Average follow-up continued for
8.5 years with repeat examinations
}
\examples{

data(wcgs)
## maybe str(wcgs) ; plot(wcgs) ...

}
\references{
Coronary Heart Disease in the Western Collaborative Group Study
Final Follow-up Experience of 8 1/2 Years Ray H. Rosenman, MD; Richard J.
Brand, PhD; C. David Jenkins, PhD; Meyer Friedman, MD; Reuben Straus, MD;
Moses Wurm, MD JAMA. 1975;233(8):872-877.
doi:10.1001/jama.1975.03260080034016.
}
\keyword{datasets}
