% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.dfts}
\alias{summary.dfts}
\title{Summary for dfts Object}
\usage{
\method{summary}{dfts}(object, changes = NULL, lag.max = 20, d.max = 2, demean = FALSE, ...)
}
\arguments{
\item{object}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{changes}{Vector of change locations, if there are any. Default is NULL.}

\item{lag.max}{Max lags to consider for ACF. Default is 20.}

\item{d.max}{Max number of dimensions for QQ-plot.}

\item{demean}{Boolean if data should be demeaned based on changes and create
plots based on these residuals.}

\item{...}{Data to pass into underlying functions like the KPSS, portmanteau,
and stationary tests. In general it is recommended to not use this and
instead apply the specialized functions directly.}
}
\value{
List with the elements:
\enumerate{
\item summary_data: summary results for the data.
\item summary_plot: summary plot for the data.
}
}
\description{
General summary function to view data overview. Several plots and test
statistics are returned to give a general view of the data. More details
can be found with more specialized functions.
}
\examples{
# All parameters extremely low for speed
res <- summary(electricity[, 1:10], lag.max = 1, d.max=1, M=10)
}
\seealso{
\code{\link[base:summary]{base::summary()}}
}
