% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space_measuring_vectors.R
\name{space_measuring_functions}
\alias{space_measuring_functions}
\title{Compute Spacing Measuring Functions}
\usage{
space_measuring_functions(X, M = 20, space = "BM")
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{M}{Integer for the number of functions to generate.}

\item{space}{String for the space of interest. Options are Brownian motion
('BM'), principal components ('PC'), and vectors in iid standard,
random normals ('RN'). Additional options are forthcoming}
}
\value{
Data.frame with columns of discretized functions describing the space.
Columns are independent functions.
}
\description{
This function is used to compute discretized functions, i.e. vectors, to
explore functional spaces.
}
\examples{
space_measuring_functions(M = 10, space = "BM", X = electricity)
space_measuring_functions(M = 10, space = "PC", X = electricity)
}
\seealso{
\code{\link[=fchange]{fchange()}}
}
