% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfts.R
\name{diff.dfts}
\alias{diff.dfts}
\title{Difference dfts}
\usage{
\method{diff}{dfts}(x, lag = 1L, differences = 1L, ...)
}
\arguments{
\item{x}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{lag}{An integer indicating which lag to use.}

\item{differences}{An integer indicating the order of the difference.}

\item{...}{Further arguments to be passed to methods.}
}
\value{
A dfts object with the differenced values.
}
\description{
Difference the functional data at some lag and iteration. For the
\eqn{\ell}'th difference at lag \eqn{m}, the differenced series is
defined as
\eqn{
   Y_i(t) = (1-B^m)^{\ell} X_i(t)
 }
where \eqn{B} is the backshift operator.
}
\examples{
result <- diff(electricity, lag = 1)
result1 <- diff(electricity, differences = 2)
}
