% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixation_dispersion.R
\name{fixation_dispersion}
\alias{fixation_dispersion}
\title{Fixation detection using a dispersion method}
\usage{
fixation_dispersion(
  data,
  min_dur = 150,
  disp_tol = 100,
  NA_tol = 0.25,
  progress = TRUE
)
}
\arguments{
\item{data}{A dataframe with raw data (time, x, y, trial) for one participant (the standardised raw data form for eyetools)}

\item{min_dur}{Minimum duration (in milliseconds) of period over which fixations are assessed}

\item{disp_tol}{Maximum tolerance (in pixels) for the dispersion of values allowed over fixation period}

\item{NA_tol}{the proportion of NAs tolerated within any window of samples that is evaluated as a fixation}

\item{progress}{Display a progress bar}
}
\value{
a dataframe containing each detected fixation by trial, with mean x/y position in pixel, start and end times, and duration.
}
\description{
Detects fixations by assessing dispersion of the eye position, using a method that is similar to that proposed by Salvucci & Goldberg (2000).
Evaluates the maximum dispersion (distance) between x/y coordinates across a window of data. Looks for sufficient periods
in which this maximum dispersion is below the specified dispersion tolerance. NAs are considered breaks
in the data and are not permitted within a valid fixation period.
}
\details{
It can take either single participant data or multiple participants, where participants are demarcated by values in the "pID" column.
}
\examples{
\donttest{
data <- combine_eyes(HCL)
fixation_dispersion(data)
}

}
\references{
Salvucci, D. D., & Goldberg, J. H. (2000). Identifying fixations and saccades in eye-tracking protocols. Proceedings of the Symposium on Eye Tracking Research & Applications - ETRA '00, 71–78.
}
