% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{lamDiff_symmetric}
\alias{lamDiff_symmetric}
\title{Difference in lambda, with the mean as baseline}
\usage{
lamDiff_symmetric(Aobj, which.fixed = NULL)
}
\arguments{
\item{Aobj}{An object containing the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where
each row is the column-wise vectorization of a matrix. Exactly 2 matrices
should be provided. If more than 2 matrices are provided, the function will
only use the first two.}

\item{which.fixed}{The column-wise indices (single-value index) of the vital
rates to be held at their mean values across the matrices in \code{Aobj}.}
}
\value{
A single value for the difference in lambda.
}
\description{
In population projection matrices, the eigenvalue with the largest magnitude
is the asymptotic population growth rate, referred to as lambda. This
function calculates the difference in lambda between two population
projection matrices, which must have the same dimensions. This function also
has the option to hold some of the vital rates at their mean values across
the provided matrices. The resulting calculation is the difference in lambda
when all the non-fixed vital rates are varying. For example, if all the vital
rates are held fixed except for adult fertility, then the output is the
difference in lambda due to difference in adult fertility. The difference is
taken as \eqn{observed matrix 1 - observed matrix 2}, where the provided
matrices are ordered [observed matrix 1, observed matrix 2].
}
\details{
This function differs from \code{lamDiff} because it uses the mean
matrix as the baseline. So fixed parameters are set to their mean values. In
\code{lamDiff}, the fixed parameters would be set to their respective values
given by the baseline matrix.

\code{lamDiff} is most appropriate for comparisons between a control and
treatment population in a controlled experiment or other settings where one
of the populations can be considered as a standard-of-reference.
\code{lamDiff_symmetric} is more appropriate for comparisons where none of
the population matrices are obviously suitable as a baseline or
standard-of-reference (for example, when comparing a wet and a dry year).
}
\examples{
Aobs1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
Aobs2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A_all<- list(Aobs1,Aobs2)
diff_all_vary<- lamDiff_symmetric(A_all)
diff_fert_vary<- lamDiff_symmetric(A_all, which.fixed=c(2,6,9))
}
\seealso{
\code{\link{lamDiff}} \code{\link{lamVar}}
}
