% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographic_fns.R
\name{fundamental_matrix}
\alias{fundamental_matrix}
\title{Fundamental matrix}
\usage{
fundamental_matrix(Umat)
}
\arguments{
\item{Umat}{The survival components of the population projection matrix.}
}
\value{
The fundamental matrix, containing the expected number of timesteps
that an individual will spend in each class of the population, given their
current state. This matrix will have the same size as the input matrix.
}
\description{
Calculate the fundamental matrix. The fundamental matrix, generally referred
to as \strong{N}, contains the expected number of timesteps that an individual
will spend in each age, stage, or size class of the matrix throughout their
lifespan, given their current class. In the fundamental matrix, the current
state is the column, and the future states are in the rows. For an
age-classified matrix, this should be lower triangular.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
U1<- A1
U1[1,3]<- 0
# the upper right corner represents adult fertility in this model. U1, the
# survival matrix, contains all the transitions *except* for fertility.
N1<- fundamental_matrix(U1)
}
