% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_gleam.R
\name{download_gleam}
\alias{download_gleam}
\title{GLEAM data downloader}
\usage{
download_gleam(
  path = "",
  domain = "raw",
  time_res = "monthly",
  variable = "e",
  version = ""
)
}
\arguments{
\item{path}{a character string with the path where the data will be downloaded.}

\item{domain}{a character string with the desired domain data set. Suitable options are:
\itemize{
\item{"raw" for default available spatial coverage,}
\item{"global" for data sets with global (land and ocean) coverage,}
\item{"land" for data sets with land only coverage,}
\item{"ocean", for data sets with ocean only coverage.}
}}

\item{time_res}{a character string with the desired time resolution. Suitable options are:
\itemize{
\item{"monthly",}
\item{"yearly",}
\item{"daily".}
}}

\item{variable}{a character string for the variable. Suitable options are:
\itemize{
\item{"e" for actual evapotranspiration,}
\item{"pet" for potential evapotranspiration.}
}}

\item{version}{an optional character string for the version. Suitable options are:
\itemize{
\item{"v3-7a" for version 3.7a,}
\item{"v4-1a" for version 4.1a,}
\item{"" for default version v3-7a.}
}}
}
\value{
No return value, called to download the data set.
}
\description{
Downloading GLEAM evapotranspiration data
}
\keyword{internal}
