% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.R
\name{plot_bar}
\alias{plot_bar}
\title{Bar plot with optional fill grouping, sorting, and directional layout}
\usage{
plot_bar(
  data,
  x,
  y,
  fill = NULL,
  direction = c("vertical", "horizontal"),
  sort = FALSE,
  sort_by = NULL,
  sort_dir = c("asc", "desc"),
  width = 0.7,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{Column name for the x-axis (quoted or unquoted).}

\item{y}{Column name for the y-axis (quoted or unquoted).}

\item{fill}{Optional character scalar. Column name to map to fill (grouping).}

\item{direction}{Plot direction: "vertical" or "horizontal". Default: "vertical".}

\item{sort}{Logical. Whether to sort bars based on y values. Default: FALSE.}

\item{sort_by}{Optional. If \code{fill} is set and \code{sort = TRUE}, choose which level
of \code{fill} is used for sorting.}

\item{sort_dir}{Sorting direction: "asc" or "desc". Default: "asc".}

\item{width}{Numeric. Bar width. Default: 0.7.}

\item{...}{Additional args passed to \code{ggplot2::geom_bar()}, e.g. \code{alpha}, \code{color}.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a bar chart from a data frame with optional grouping (\code{fill}),
vertical/horizontal orientation, and sorting by values.
}
