% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rain.R
\name{rain}
\alias{rain}
\title{conversion of model precipitation to hourly precipitation}
\usage{
rain(rainc, rainnc, verbose = TRUE)
}
\arguments{
\item{rainc}{data.frame or SpatRaster with RAINC variable}

\item{rainnc}{data.frame or SpatRaster with RAINNC variable}

\item{verbose}{set TRUE to display additional information}
}
\value{
data.frame time and the hourly precipitation or SpatRaster hourly precipitation
}
\description{
function that converts model accumulated precipitation to hourly precipitation.
}
\examples{
times <- seq(as.POSIXct('2024-01-01',tz = 'UTC'),
             as.POSIXct('2024-01-01 04:00:00',tz = 'UTC'),
             by = 'hour')
RNC   <- data.frame(date = times, aa = c(0.149,0.149,0.149,0.149,0.149))
RNNC  <- data.frame(date = times, aa = c(0.919,1.0,1.1,1.1,2.919))
rain(rainc = RNC, rainnc = RNNC)
}
