% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egor.R
\name{template_network}
\alias{template_network}
\alias{template_network.data.frame}
\alias{template_network.egor}
\title{Construct an Empty ``Template'' Network Consistent with an Egocentric Sample}
\usage{
template_network(x, ...)

\method{template_network}{data.frame}(x, ...)

\method{template_network}{egor}(x, N, scaling = c("round", "sample"), ...)
}
\arguments{
\item{x}{A \code{\link[egor:egor]{egor}} object.}

\item{...}{Additional arguments, currently unused.}

\item{N}{The target number of vertices the output network should have.}

\item{scaling}{If \code{\link[egor:egor]{egor}} contains weights or \code{N} is not
a multiple of number of egos in the sample, it may not be possible, for a
finite \code{N} to represent each ego exactly according to its relative
weight, and \code{scaling} controls how the fractional egos are allocated:
\describe{ \item{"round"}{(the default) Rather than treating \code{N} as a hard
setting, calculate \eqn{N w_i / w_\cdot} for each ego \eqn{i} and round it
to the nearest integer. Then, the \code{N} actually used will be the sum of
these rounded freqencies.} \item{"sample"}{Resample in
proportion to \eqn{w_i}.} }}
}
\value{
A \code{\link[network:network]{network}} object.
}
\description{
Taking an object with ego information, constructs a
\code{\link[network:network]{network}} object with no edges whose vertices have the
attributes of the egos in the dataset, replicating the egos as needed, and
taking into accounts their sampling weights.
}
\section{Methods (by class)}{
\itemize{
\item \code{template_network(data.frame)}: method for \code{\link{data.frame}}s and \code{\link[tibble:tibble]{tibble}}s, specifying ego composition directly.

\item \code{template_network(egor)}: method for \code{\link[egor:egor]{egor}} objects; weights, if any, are obtained from the \code{egor}'s design information.

}}
\examples{


data(faux.mesa.high)
summary(faux.mesa.high, print.adj = FALSE)

fmh.ego <- as.egor(faux.mesa.high)

# Same actor attributes
fmh.template <- template_network(fmh.ego, N=network.size(faux.mesa.high))
summary(fmh.template, print.adj = FALSE)

# Twice the actors, same distribution
fmh2.template <- template_network(fmh.ego, N=2*network.size(faux.mesa.high))
summary(fmh2.template, print.adj = FALSE)

}
\seealso{
\code{\link[=as.egor.network]{as.egor.network()}}, which performs the inverse
operation.
}
\author{
Pavel N. Krivitsky
}
\keyword{manip}
