% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_devlin.R
\name{table_3_3}
\alias{table_3_3}
\title{Table 3.3 EQ-5D values: by age and groupvar}
\usage{
table_3_3(
  df,
  names_eq5d = NULL,
  name_fu = NULL,
  levels_fu = NULL,
  name_groupvar,
  name_age,
  eq5d_version = NULL,
  country
)
}
\arguments{
\item{df}{Data frame with the EQ-5D, age, follow-up and grouping columns}

\item{names_eq5d}{Character vector of column names for the EQ-5D dimensions}

\item{name_fu}{Character string for the follow-up column}

\item{levels_fu}{Character vector containing the order of the values in the follow-up column. 
If NULL (default value), the levels will be ordered in the order of appearance in df.}

\item{name_groupvar}{Character string for the grouping column}

\item{name_age}{Character string for the age column}

\item{eq5d_version}{Version of the EQ-5D instrument}

\item{country}{A character string representing the name of the country. 
This could be in a 2-letter format, full name or short name, as specified in the country_codes datasets.}
}
\value{
Summary data frame
}
\description{
Table 3.3 EQ-5D values: by age and groupvar
}
\examples{
example_data$ageband <- factor(
  example_data$ageband,
  levels = c("20 to 29", "30 to 39", "40 to 49", "50 to 59", "60 to 69", "70 to 79", "80 to 89")
)
example_data <- example_data[example_data$gender \%in\% c("Male", "Female"),]
table_3_3(
  example_data,
  names_eq5d = c("mo", "sc", "ua", "pd", "ad"),
  name_fu = "time",
  levels_fu = c('Pre-op', 'Post-op'),
  name_groupvar = "gender",
  name_age = "ageband",
  eq5d_version = "3L",
  country = "UK"
)
}
