% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-ui.R
\name{epiworldrshiny-ui}
\alias{epiworldrshiny-ui}
\alias{text_input_disease_name}
\alias{slider_prevalence}
\alias{numeric_input_ndays}
\alias{slider_input_rate}
\alias{network_input}
\alias{npis_input}
\alias{seed_input}
\alias{models_setup}
\alias{population_input}
\alias{simulate_button}
\title{epiworldRShiny UI builder functions}
\usage{
text_input_disease_name(model_name)

slider_prevalence(model_name)

numeric_input_ndays(model_name)

slider_input_rate(model_name, rate_name, value, maxval = 1, input_label = NULL)

network_input(model_name)

npis_input(model_name)

seed_input(model_name)

models_setup(custom_models_path = NULL)

population_input(model_name)

simulate_button(model_name)
}
\arguments{
\item{model_name}{Name of the epiworldR model.}

\item{rate_name}{Name of the rate.}

\item{value}{Initial value for the slider.}

\item{maxval}{Maxiumum value for the slider.}

\item{input_label}{Aids in creating the appropriate slider name.}

\item{custom_models_path}{Optional path to custom model files (see details).}
}
\value{
\itemize{
\item Unless otherwise specified, returns an object of class shiny.tag.
}

\itemize{
\item \code{network_input} returns an object of class \link[shiny:reexports]{shiny::tagList} (\code{shiny.tag.list}).
}

\itemize{
\item \code{npis_input} returns an object of class \link[shiny:reexports]{shiny::tagList} (\code{shiny.tag.list}).
}

\itemize{
\item \code{models_setup} returns an object of class list.
}

\itemize{
\item \code{population_input} returns an object of class shiny.tag.list.
}
}
\description{
All functions in this section are for internal use only. They are used to
build the UI for the epiworldRShiny app.
}
\details{
When \code{custom_models_path} is specified, the function will look for valid model files
at the specified path. These will be added to the list of available models.
The function expects R files named \verb{shiny_<model_name>.R} which contain the model.
}
\examples{
text_input_disease_name("SEIRD")
slider_prevalence("SEIRD")
numeric_input_ndays("SEIRD")
slider_input_rate("SEIRD", "transmission", value = 0.3, maxval = 1,
input_label = NULL)
network_input("SEIRD")
npis_input("SEIRD")
seed_input("SEIRD")
# Setup with default models only:
models_setup()
# Setup with default and custom models:
\dontrun{models_setup(custom_models_path = "path/to/custom/models")}
population_input("SEIRD")
simulate_button("SEIRD")
}
