% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_report_ytd_medians}
\alias{create_report_ytd_medians}
\title{Create year-to-date (YTD) medians report}
\usage{
create_report_ytd_medians(data, diseases, m)
}
\arguments{
\item{data}{Dataframe. Input data with columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}

\item{diseases}{Character vector. Diseases to include in the report}

\item{m}{Integer. Report month (1-12)}
}
\value{
Dataframe with one row per disease and columns for disease name and
median YTD counts.
}
\description{
'create_report_ytd_medians' generates a data frame of median year-to-date
counts for each disease up to the given month (months \code{1:m}) across all years in the data.
This provides a robust central tendency measure for YTD values.
}
\examples{
data <- data.frame(
  disease = c("A", "A", "A", "B", "B", "B"),
  year = c(2022, 2023, 2024, 2022, 2023, 2024),
  month = c(1, 1, 2, 2, 2, 3),
  counts = c(10, 15, 20, 5, 8, 12)
)
create_report_ytd_medians(data, c("A", "B", "C"), 2)
}
