% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanism.R
\name{mechanism}
\alias{mechanism}
\alias{new_mechanism}
\alias{validate_mechanism}
\alias{plot.epicmodel_mechanism}
\alias{print.epicmodel_mechanism}
\title{Investigate mechanisms}
\usage{
mechanism(scc, modules = TRUE, module_colors = NULL)

new_mechanism(x = list())

validate_mechanism(x)

\method{plot}{epicmodel_mechanism}(x, reverse = TRUE, ...)

\method{print}{epicmodel_mechanism}(x, ...)
}
\arguments{
\item{scc}{For \code{mechanism()}, an object of class \code{epicmodel_scc}.}

\item{modules}{For \code{mechanism()}, TRUE (default) or FALSE, indicating if nodes in the same module should be colored equally (TRUE) or if all
nodes have white background (FALSE). Colors are only applied, if modules have actually been specified in the \code{epicmodel_steplist}. If modules
are considered by \code{mechanism()}, the module keywords are added to the legend (accessable via \code{print()}).}

\item{module_colors}{For \code{mechanism()}, if nodes are colored by module, colors can be provided via this argument. Colors must be provided as a
character vector. Both named colors and hexadecimal color codes are allowed. The function has 8 colors stored internally.
If \code{module_colors} = NULL (default), these colors are used. If the model has more than 8 modules, \code{module_colors} must be specified. If more
colors than necessary are specified, the function takes as many as necessary from the start of the vector.}

\item{x}{\code{x} is used in several functions:
\itemize{
\item \code{new_mechanism()}: A list to be converted to class \code{epicmodel_mechanism}.
\item \code{validate_mechanism()}: An object of class \code{epicmodel_mechanism} to be validated.
\item \code{plot.epicmodel_mechanism()}: An object of class \code{epicmodel_mechanism}.
\item \code{print.epicmodel_mechanism()}: An object of class \code{epicmodel_mechanism}.
}}

\item{reverse}{For \code{plot.epicmodel_mechanism()}, TRUE or FALSE indicating if the output should be displayed in reverse order. Since graphs
rendered later show up first in the viewer pane, reverse = T leads to SC1 being the last rendered and the one displayed on top.}

\item{...}{Additional arguments for generics \code{print()} and \code{plot()}.}
}
\value{
\itemize{
\item \code{mechanism()}: An object of class \code{epicmodel_mechanism}. Use \code{plot()} to plot the graphs in the RStudio Viewer. Use \code{print()} to print the
legend in the console. Use \code{\link[=export_mechanism]{export_mechanism()}} to save the graphs as PNG, PDF, SVG, or PostScript.
\item \code{new_mechanism()}: An object of class \code{epicmodel_mechanism}.
\item \code{validate_mechanism()}: An object of class \code{epicmodel_mechanism} that has been checked to have the correct structure.
\item \code{plot.epicmodel_mechanism()}: Renders the graphs in the RStudio Viewer.
\item \code{print.epicmodel_mechanism()}: Prints the legend of the \code{epicmodel_mechanism} object in the console.
}
}
\description{
Creates graphs that visiualize the mechanisms behind each sufficient cause using the \code{DiagrammeR} package.

\code{new_mechanism()} and \code{validate_mechanism()} define the \code{epicmodel_mechanism} S3 class, which is created by \code{mechanism()}.

\code{plot()} renders the graphs in the RStudio Viewer.

\code{print()} prints the legend for node labels in the console.
}
\details{
\subsection{The graphs}{

One graph per sufficient cause is created. The graphs display steps as nodes and IF/IFNOT relations as edges. Nodes will not be
labeled with their IDs or descriptions due to limited space, but with newly created labels. These labels are based on the type of node and are
listed together with the step description in the \code{legend} (accessed by \code{print()}). Step descriptions are also accessible via tooltips in the
graph. Just put your cursor on the node labels.

There are 4 different types of nodes:
\itemize{
\item \verb{Component causes}: Labeled \code{"CC"}, squares, gray border
\item \code{Interventions}: Labeled \code{"I"}, triangles, gray border
\item \verb{End steps}: Labeled \code{"E"}, circles, black border
\item \verb{Other steps}: Labeled \code{"S"}, circles, gray border
}

There are 2 types of edges:
\itemize{
\item \verb{IF conditions}: gray arrows
\item \verb{IFNOT conditions}: red and T-shaped
}
}

\subsection{\code{epicmodel_mechanism} objects}{

\code{epicmodel_mechanism} objects are created by \code{mechanism()}. They are lists containing 2 elements:
\describe{
\item{\code{legend}}{A data.frame with up to 3 variables:
\itemize{
\item \code{Label}: Contains the labels used in the graphs.
\item \code{Module}: Contains the name of the module to which this step belongs. Only available if \code{modules = TRUE} in \code{mechanism()} and if the SCC
model actually uses modules (specified in element \code{sc_use_modules} of \code{epicmodel_scc} objects).
\item \code{Step}: A description of the corresponding step.}
}

\item{\code{graph}}{A list of length equal to the number of sufficient causes. Each element contains another list with 2 elements:
\itemize{
\item \code{ndf}: A data.frame containing information about nodes in the graph (see \code{\link[DiagrammeR:node_aes]{DiagrammeR::node_aes()}}).
\item \code{edf}: A data.frame containing information about edges in the graph (see \code{\link[DiagrammeR:edge_aes]{DiagrammeR::edge_aes()}}).}
}

\item{\code{ndf}}{Data.frames containing the following variables:
\itemize{
\item \code{id}: Node ID used internally by \code{DiagrammeR} to define edges (\code{from} and \code{to} in \code{edf} data.frames).
\item \code{type}: Type of node as defined by \code{epicmodel}. Possible options are: \code{cc} (component cause), \code{int} (intervention), \code{end} (step that is part
of an outcome definition), \code{other} (all other steps).
\item \code{label}: The label displayed in the graph and listed in variable \code{Label} of \code{legend}.
\item \code{tooltip}: The text displayed when putting the cursor on top of the node label. Corresponds to the step descriptions in variable \code{Step} of
\code{legend}.
\item \code{shape}: The shape of the node. \code{square} for type \code{cc}, \code{triangle} for type \code{int}, and \code{circle} for types \code{end} and \code{other}.
\item \code{color}: Color of the node border. Gray for types \code{cc}, \code{int}, and \code{other}, and black for type \code{end}.
\item \code{fillcolor}: Color of the background, which is similar for all steps in the same module. If modules are not considered, \code{fillcolor} is white
for all nodes.
\item \code{fontcolor}: Color of the node label. Always black.}
}

\item{\code{edf}}{Data.frames containing the following variables:
\itemize{
\item \code{id}: Edge ID used internally by \code{DiagrammeR}.
\item \code{from}: Node ID of the node from which the edge starts.
\item \code{to}: Node ID of the node at which the edge ends.
\item \code{rel}: Type of edge as defined by \code{epicmodel}. Possible options are: \code{if} (\code{from} node is in IF condition of \code{to} node), \code{ifnot} (\code{from} node
is in IFNOT condition of \code{to} node).
\item \code{arrowhead}: Type of arrow. \code{normal} for rel \code{if} and \code{tee} for rel \code{ifnot}.
\item \code{arrowsize}: Size of arrow. 1 for rel \code{if} and 1.2 for rel \code{ifnot}.
\item \code{color}: Color of arrow. Gray for rel \code{if} and \verb{#A65141} for rel \code{ifnot}.}
}
}
}
}
\examples{
# Create some SCC model
steplist_checked <- check_steplist(steplist_rain)
scc_model <- create_scc(steplist_checked)

# Derive mechanisms
mech <- mechanism(scc_model)

# new_mechanism() and validate_mechanism() are used inside mechanism()
# nonetheless, you can check its structure using validate_mechanism()
validate_mechanism(mech)

# Plot the mechanisms
plot(mech)

# Print the legend
print(mech)
mech

}
\seealso{
\itemize{
\item \code{\link[=export_mechanism]{export_mechanism()}} for saving the plots
\item \code{\link[DiagrammeR:node_aes]{DiagrammeR::node_aes()}} for a list of node-related variables in \code{DiagrammeR}
\item \code{\link[DiagrammeR:edge_aes]{DiagrammeR::edge_aes()}} for a list of edge-related variables in \code{DiagrammeR}
}
}
