% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/news.R
\name{get_news}
\alias{get_news}
\title{Retrieves news for a given ticker and exchange}
\usage{
get_news(
  ticker = "AAPL",
  exchange = "US",
  first_date = Sys.Date() - 3 * 30,
  last_date = Sys.Date(),
  offset_delta = 500,
  cache_folder = get_default_cache(),
  check_quota = TRUE
)
}
\arguments{
\item{ticker}{A company ticker (e.g. AAPL). You can find all tickers for a particular exchange with \code{\link[=get_tickers]{get_tickers()}}.}

\item{exchange}{A exchange symbol (e.g. US). You can find all tickers for a particular exchange with \code{\link[=get_tickers]{get_tickers()}}. Be aware that, for US companies, the exchange symbols is simply "US"}

\item{first_date}{the first date to fetch news. The function will keep querying the api
until this date is reached. Default is previous three months.}

\item{last_date}{the last date to fetch news. Default is today.}

\item{offset_delta}{how much to change offset in each iterations (higher values will result
in more query time, but less queries). Default is 500.}

\item{cache_folder}{A local directory to store cache files. By default, all functions use a temporary path, meaning that the caching system
is session persistent (it will remove all files when you exit your R session). If you want a persistent caching system, simply point argument
cache_folder to a local directory in your filesystem. Be aware, however, that a persistent cache will not refresh your data for new api queries.}

\item{check_quota}{A flag (TRUE/FALSE) for whether to check the current quota status from the api. This option implies a small cost of execution
time. If you need speed, just set it to FALSE.}
}
\value{
A dataframe with news events and sentiments
}
\description{
This function will query the news point of eodhd and return all news for a user
supplied time period.
}
\examples{
\dontrun{
set_token(get_demo_token())
df_news <- get_news(ticker = "AAPL", exchange = "US")
}
}
