% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{write_path}
\alias{write_path}
\title{Retrieve a file path from an envsetup object containing paths}
\usage{
write_path(
  lib,
  filename = NULL,
  envsetup_environ = Sys.getenv("ENVSETUP_ENVIRON"),
  envir = getOption("envsetup.path.environment")
)
}
\arguments{
\item{lib}{Object containing the paths for all environments of a directory}

\item{filename}{Name of the file you would like to write}

\item{envsetup_environ}{Name of the environment to which you would like to
write. Defaults to the ENVSETUP_ENVIRON environment variable}

\item{envir}{The environment to search for the path object. Defaults to the
value of \code{getOption("envsetup.path.environment")}.}
}
\value{
path to write
}
\description{
Paths will be filtered to produce the lowest available level from a hierarchy
of paths based on envsetup_environ
}
\examples{
tmpdir <- tempdir()

# account for windows
if (Sys.info()['sysname'] == "Windows") {
  tmpdir <- gsub("\\\\", "\\\\\\\\", tmpdir, fixed = TRUE)
}

# add config for just the data location
hierarchy <- paste0("default:
  paths:
    data: !expr list(
      DEV = file.path('",tmpdir,"', 'demo', 'DEV', 'username', 'project1', 'data'),
      PROD = file.path('",tmpdir,"', 'demo', 'PROD', 'project1', 'data'))")

# write config file to temp directory
writeLines(hierarchy, file.path(tmpdir, "hierarchy.yml"))

config <- config::get(file = file.path(tmpdir, "hierarchy.yml"))

# build folder structure from config
build_from_config(config)

# setup environment based on config
rprofile(config::get(file = file.path(tmpdir, "hierarchy.yml")))

# find location to write mtcars.rds
write_path(data, "mtcars.rds")

# save data in data folder using write_path
saveRDS(mtcars, write_path(data, "mtcars.rds"))
}
