% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cssem_polynomial.R
\name{cssem_polynomial}
\alias{cssem_polynomial}
\title{Polynomial Method for CSSEM}
\usage{
cssem_polynomial(csemx, ct, K = 10, gra = TRUE)
}
\arguments{
\item{csemx}{A data frame or matrix containing raw scores and their CSEM on
the raw-score metric. It must have at least the following numeric columns:
\itemize{
\item \code{x}: raw scores,
\item \code{csem}: conditional standard errors of measurement on the
raw-score metric.
}}

\item{ct}{A data frame or matrix containing the score conversion table. It
must have at least the following numeric columns:
\itemize{
\item \code{x}: raw scores (matching those in \code{csemx}),
\item \code{ss}: scale scores corresponding to each raw score.
}}

\item{K}{Integer. Highest polynomial degree to fit. Defaults to \code{10}.}

\item{gra}{Logical. If \code{TRUE}, a plot of the fitted polynomial curve
and the observed conversion points is produced for each degree \code{k}.}
}
\value{
A list with two components:
\describe{
\item{rsquared}{A matrix with one column containing the R-squared values
from polynomial fits of degree \code{k = 1, \dots, K}, where
\code{K} is the largest successfully fitted degree.}
\item{cssempoly}{A data frame containing the merged data
(\code{x}, \code{csem}, \code{ss}) and, for each degree \code{k},
the additional columns:
\itemize{
\item \code{fx_k1}, \code{fx_k2}, \dots: transformation derivatives
\eqn{f'_k(x)} for each raw score,
\item \code{ss_k1}, \code{ss_k2}, \dots: fitted (rounded) scale scores
from the polynomial of degree \code{k},
\item \code{cssem_k1}, \code{cssem_k2}, \dots: CSSEM values on
the scale-score metric, computed as \eqn{f'_k(x)\,\mathrm{CSEM}_x}.
}}
}
}
\description{
Implement the polynomial method for computing conditional standard errors of
measurement for scale scores (CSSEM). A polynomial regression of scale scores
on raw scores is fit for degrees 1 through \code{K}; for each degree \code{k},
the transformation derivative is used to map raw-score CSEM values to
scale-score CSSEM values.
}
\details{
At the beginning of the function, \code{csemx} and \code{ct} are merged by
the \code{x} column (inner join) to create an internal data frame . Only
rows with \code{x} values present in both inputs are
used. The polynomial model is then fit to \code{ss ~ poly(x, k, raw = TRUE)}
for \code{k = 1, \dots, K}.
}
\examples{
data(ct.u)
cssem_polynomial(as.data.frame(csem_lord(40)), ct.u, K = 4, gra = TRUE)

}
