% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_pred}
\alias{compare_pred}
\alias{compare_pred.emdi}
\title{Compare Predictions of Model Objects}
\usage{
compare_pred(object1, object2, MSE = FALSE, ...)

\method{compare_pred}{emdi}(object1, object2, MSE = FALSE, ...)
}
\arguments{
\item{object1}{an object of type "emdi".}

\item{object2}{an object of type "emdi".}

\item{MSE}{if \code{TRUE}, MSE estimates are also returned. Defaults to
\code{FALSE}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Data frame containing the point estimates of both emdi objects. If
column names are duplicated, the suffixes "_1" and "_2" are added to their
names. "_1" and "_2" standing for object1 and object2, respectively. If
\code{MSE} is set to \code{TRUE}, the data frame also contains the MSE
estimates of the emdi objects.
}
\description{
Function \code{compare_pred} is a generic function used to compare
predictions of two model objects.

Method \code{compare_pred.emdi} compares predictions of two emdi objects.
}
\examples{
\donttest{
# Example for class ebp
emdi_model_1 <- ebp(
  fixed = eqIncome ~ gender + eqsize + cash + self_empl +
    unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + fam_allow +
    house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
  pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
  na.rm = TRUE
)

emdi_model_2 <- ebp(
  fixed = eqIncome ~ gender + eqsize + cash + self_empl +
    unempl_ben + age_ben + surv_ben, pop_data = eusilcA_pop,
  pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
  na.rm = TRUE
)

compare_pred(emdi_model_1, emdi_model_2)
}
}
\seealso{
\code{\link{direct}}, \code{\link{ebp}}, \code{\link{fh}}
}
