% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personal_finances_fed.R
\name{personal_finances_fed}
\alias{personal_finances_fed}
\title{Download data on federal candidates' personal financial disclosures}
\usage{
personal_finances_fed(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE
)
}
\arguments{
\item{year}{Election year. For this function, only the years 2006, 2010, 2014, 2018, and 2022 are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recovers only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}
}
\value{
\code{personal_finances_fed()} returns a \code{data.frame}.
}
\description{
\code{personal_finances_local()} downloads and aggregates the data on federal candidates' personal financial disclosures. The function returns a \code{data.frame} where each observation corresponds to a candidate's property.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information may be incomplete.
}
\examples{
\dontrun{
df <- personal_finances_fed(2006)
}
}
