% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elections_cepesp.R
\name{elections_cepesp}
\alias{elections_cepesp}
\title{Retrieve electoral data from the cepesp API.}
\usage{
elections_cepesp(year, type, position, data_table = FALSE)
}
\arguments{
\item{year}{The election year. Valid options are between 1998 to 2018 for positions such as President, Governor, Senator, Federal Deputy, State Deputy, and District Deputy. For Mayor or Councillor positions, valid options range from 2000 to 2016.}

\item{type}{The type of data to retrieve. Valid options are "candidate" or "vote".}

\item{position}{The position for which the data is requested. Valid options are President, Governor, Senator, Federal Deputy, State Deputy, District Deputy, Mayor, or Councillor.}

\item{data_table}{If set to TRUE, the function will return the data as a data.table object. Default is FALSE.}
}
\value{
The function returns a tibble containing the requested elections data.
}
\description{
Retrieve electoral data from the cepesp API.
}
\note{
The function is a wrapper for the cepesp API. To learn more about the API, please visit cepespdata.io.
}
\examples{
\dontrun{
df <- elections_cepesp(2018, type = "candidate", position = "President")
}
}
